% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huePositionPlot.R
\name{huePositionPlot}
\alias{huePositionPlot}
\title{Hue Position Chart}
\usage{
huePositionPlot(
  value = 6,
  chroma = 6,
  chip.cex = 4.5,
  label.cex = 0.75,
  contour.dE00 = FALSE,
  grid.res = 2
)
}
\arguments{
\item{value}{a single Munsell value}

\item{chroma}{a single Munsell chroma}

\item{chip.cex}{scaling for color chip rectangle}

\item{label.cex}{scaling for color chip}

\item{contour.dE00}{logical, add dE00 contours from CIELAB coordinates (L,0,0), L is a constant value determined by \code{value} and \code{chroma}}

\item{grid.res}{grid resolution for contours, units are CIELAB A/B coordinates. Caution, small values result in many pair-wise distances which could take a very long time.}
}
\description{
A simple visualization of the hue positions for a given Munsell value/chroma according to \href{https://www.nrcs.usda.gov/wps/portal/nrcs/detail/soils/ref/?cid=nrcs142p2_053569}{Soil Survey Technical Note 2}.
}
\examples{

huePositionPlot(value = 4, chroma = 4)

huePositionPlot(value = 6, chroma = 6)

huePositionPlot(value = 8, chroma = 8)

huePositionPlot(value = 6, chroma = 6, contour.dE00 = TRUE, grid.res = 2)

}
