% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Moran_I_ByRaster.R
\name{Moran_I_ByRaster}
\alias{Moran_I_ByRaster}
\title{Compute Moran's I for a raster sampled from a mapunit extent}
\usage{
Moran_I_ByRaster(
  r,
  mu.extent = NULL,
  n = NULL,
  k = NULL,
  do.correlogram = FALSE,
  cor.order = 5,
  crop.raster = TRUE
)
}
\arguments{
\item{r}{single \code{RasterLayer}}

\item{mu.extent}{\code{SpatialPolygons} representation of mapunit polygons bounding box (via \code{raster::extent()})}

\item{n}{number of regular samples (what is a reasonable value?)}

\item{k}{number of neighbors used for weights matrix}

\item{do.correlogram}{compute correlogram?}

\item{cor.order}{order of correlogram}

\item{crop.raster}{optionally disable cropping of the raster layer}
}
\value{
If \code{do.correlogram} is \code{TRUE} a list with estimated Moran's I (\verb{$I}) and the correlogram (\verb{$correlogram}), otherwise the estimated Moran's I value.
}
\description{
Compute Moran's I using a subset of sample collected within the extent of a mapunit. This is likely an under-estimate of SA because we are including pixels both inside/outside MU delineations
}
\details{
This function uses the \code{spdep::moran.test()} function
}
\author{
D.E. Beaudette
}
