% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleWB.R
\name{simpleWB}
\alias{simpleWB}
\title{Simple interface to the hydromad "leaky bucket" soil moisture model}
\usage{
simpleWB(
  PPT,
  PET,
  D,
  thickness,
  sat,
  fc,
  pwp,
  S_0 = 0.5,
  a.ss = 0.05,
  M = 0,
  etmult = 1
)
}
\arguments{
\item{PPT}{precipitation series (mm)}

\item{PET}{potential ET series (mm)}

\item{D}{dates}

\item{thickness}{soil thickness (cm)}

\item{sat}{volumetric water content at saturation (satiated water content)}

\item{fc}{volumetric water content at field capacity (typically 1/3 bar suction)}

\item{pwp}{volumetric water content at permanent wilting point (typically 15 bar suction)}

\item{S_0}{initial soil moisture as a fraction of total water storage (mm)}

\item{a.ss}{recession coefficients for subsurface flow from saturated zone, should be > 0}

\item{M}{fraction of area covered by deep-rooted vegetation}

\item{etmult}{multiplier for PET}
}
\value{
a \code{data.frame}
}
\description{
Simple interface to the hydromad "leaky bucket" soil moisture model.
}
\details{
Adjustments for coarse fragments should be made by reducing \code{thickness}.
}
\references{
Farmer, D., M. Sivapalan, Farmer, D. (2003). Climate, soil and vegetation controls upon the variability of water balance in temperate and semiarid landscapes: downward approach to water balance analysis. Water Resources Research 39(2), p 1035.

Bai, Y., T. Wagener, P. Reed (2009). A top-down framework for watershed model evaluation and selection under uncertainty. Environmental Modelling and Software 24(8), pp. 901-916.
}
