% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistToNearest.R
\name{findThreshold}
\alias{findThreshold}
\title{Find distance threshold}
\usage{
findThreshold(data, method = c("gmm", "density"), cutEdge = 0.9,
  cross = NULL, subsample = NULL)
}
\arguments{
\item{data}{numeric vector containing nearest neighbor distances.}

\item{method}{string defining the method to use for determining the optimal threshold.
One of \code{"gmm"} or \code{"density"}. See Details for methodological
descriptions.}

\item{cutEdge}{upper range (a fraction of the data density) to rule initialization of 
Gaussian fit parameters. Default value is equal to 90% of the entries.
Applies only to the \code{"gmm"} method.}

\item{cross}{supplementary nearest neighbor distance vector output from \link{distToNearest} 
for initialization of the Gaussian fit parameters. 
Applies only to the \code{"gmm"} method.}

\item{subsample}{number of distances to subsample for speeding up bandwidth inference.
Applies only to the \code{"density"} method. If \code{NULL} no subsampling
is performed. As bandwith inferrence is computationally expensive, subsampling
is recommended for large data sets.}
}
\value{
\itemize{
  \item \code{"gmm"} method:      Returns a \link{GmmThreshold} object including the optimum 
                                  \code{threshold} and the Gaussian fit parameters.
  \item \code{"density"} method:  Returns a \link{DensityThreshold} object including the optimum 
                                  \code{threshold} and the density fit parameters.
}
}
\description{
\code{findThreshold} automtically determines and optimal threshold for clonal assignment of
Ig sequences using a vector of nearest neighbor distances. It provides two alternative methods 
using either a Guassian Mixture Model fit (\code{method="gmm"}) or kernel density 
fit (\code{method="density"}).
}
\details{
\itemize{ 
  \item \code{"gmm"}:     Performs a Gaussian Mixture Model (GMM) procedure, 
                          including the Expectation Maximization (EM) algorithm, for learning 
                          the parameters  of two univariate Gaussians which fit the bimodal 
                          distribution entries. Retrieving the fit parameters, it then calculates
                          the optimum threshold, where the average of the sensitivity plus 
                          specificity reaches its maximum.
  \item \code{"density"}: Fits a binned approximation to the ordinary kernel density estimate
                          to the nearest neighbor distances after determining the optimal
                          bandwidth for the density estimate via least-squares cross-validation of 
                          the 4th derivative of the kernel density estimator. The optimal threshold
                          is set as the minimum value in the valley in the density estimate
                          between the two modes of the distribution.
}
}
\examples{
\donttest{
# Subset example data to one sample as a demo
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, SAMPLE == "-1h")

# Use nucleotide Hamming distance and normalize by junction length
db <- distToNearest(db, model="ham", normalize="len", nproc=1)
                            
# Find threshold using the "gmm" method
output <- findThreshold(db$DIST_NEAREST, method="gmm")
print(output)
# Plot "gmm" method results
plot(output, binwidth=0.02)

# Find threshold using the "density" method 
output <- findThreshold(db$DIST_NEAREST, method="density")
print(output)
# Plot "density" method results
plot(output)
}
}
\seealso{
See \link{distToNearest} for generating the nearest neighbor distance vectors.
          See \link{plotGmmThreshold} and \link{plotDensityThreshold} for plotting output.
}
