% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info-box.R
\name{info_box}
\alias{info_box}
\title{Generates 'HTML' info box}
\usage{
info_box(
  ...,
  icon = "envelope",
  class = "",
  class_icon = "bg-info",
  class_content = "",
  root_path = template_root()
)
}
\arguments{
\item{...}{box content}

\item{icon}{the box icon; default is \code{"envelope"}, can be hidden by
specifying \code{NULL}}

\item{class}{class of the box container}

\item{class_icon}{class of the icon}

\item{class_content}{class of the box body}

\item{root_path}{see \code{\link{template_root}}}
}
\value{
'HTML' tags
}
\description{
Generates 'HTML' info box
}
\examples{

library(shiny)
library(shidashi)

info_box("Message", icon = "cogs")

info_box(
  icon = "thumbs-up",
  span(class = "info-box-text", "Likes"),
  span(class = "info-box-number", "12,320"),
  class_icon = "bg-red"
)

info_box("No icons", icon = NULL)

}
