% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jdatetime.R
\name{jdatetime}
\alias{jdatetime}
\alias{jdatetime.character}
\title{Date-time based on the Jalali calendar}
\usage{
jdatetime(x, tzone = "", ...)

\method{jdatetime}{character}(x, tzone = "", format = NULL, ...)
}
\arguments{
\item{x}{A vector of numeric or character objects.}

\item{tzone}{A time zone name. Default value represents local time zone.}

\item{...}{Arguments passed on to further methods.}

\item{format}{Format argument for character method.}
}
\value{
A vector of \code{jdatetime} objects.
}
\description{
\code{jdatetime} is an S3 class for representing date-times with the Jalali calendar dates.
It can be constructed from character and numeric vectors.
}
\details{
\code{jdatetime} is stored internaly as a double vector and has a single
attribute: the timezone (tzone). Its value represents the count of seconds
since the Unix epoch (a negative value if it represents an instant prior to the epoch).
This implementation coincides with that of \code{POSIXct} class, except that \code{POSIXct}
may not have \code{tzone} attribute. But for \code{jdatetime}, \code{tzone} is not optional.
}
\examples{
## default time zone and format
jdatetime("1402-09-20 18:57:09")
jdatetime("1402/09/20 18:57:09", tzone = "UTC", format = "\%Y/\%m/\%d \%H:\%M:\%S")
## Will replace invalid format with NA
jdatetime("1402/09/20 18:57:09", format = "\%Y-\%m-\%d \%H:\%M:\%S")
## nonexistent time will be replaced with NA
jdatetime("1401-01-02 00:30:00", tzone = "Asia/Tehran")
## ambiguous time will be replaced with NA
jdatetime("1401-06-30 23:30:00", tzone = "Asia/Tehran")
## Jalali date-time in Iran time zone, corresponding to Unix epoch
jdatetime(0, "Iran")
}
