% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R, R/setters.R
\name{sh_hour}
\alias{sh_hour}
\alias{sh_minute}
\alias{sh_second}
\alias{sh_hour.jdatetime}
\alias{sh_minute.jdatetime}
\alias{sh_second.jdatetime}
\alias{sh_hour<-}
\alias{sh_minute<-}
\alias{sh_second<-}
\alias{sh_hour<-.jdatetime}
\alias{sh_minute<-.jdatetime}
\alias{sh_second<-.jdatetime}
\title{Get/set the time components of \code{jdatetime} objects}
\usage{
sh_hour(x)

sh_minute(x)

sh_second(x)

\method{sh_hour}{jdatetime}(x)

\method{sh_minute}{jdatetime}(x)

\method{sh_second}{jdatetime}(x)

sh_hour(x) <- value

sh_minute(x) <- value

sh_second(x) <- value

\method{sh_hour}{jdatetime}(x) <- value

\method{sh_minute}{jdatetime}(x) <- value

\method{sh_second}{jdatetime}(x) <- value
}
\arguments{
\item{x}{A vector of \code{jdatetime} objects.}

\item{value}{A numeric vector.}
}
\value{
An integer vector representing the hour, minute or second component of x,
depending on the function being called.
}
\description{
Get/set the time components of \code{jdatetime} objects
}
\details{
For assignment, \code{x} and \code{value} are recycled to their common size using
\link[vctrs:theory-faq-recycling]{tidyverse recycling rules}.
}
\examples{
x <- jdatetime("1402-12-14 19:13:31")
sh_second(x)
sh_hour(x) <- 17:18
}
