% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translator.R
\name{Translator}
\alias{Translator}
\title{Translator R6 Class}
\description{
Translator R6 Class

Translator R6 Class
}
\details{
This creates shinny.i18n Translator object used for translations.
Now you can surround the pieces of the text you want to translate by
one of the translate statements (ex.: \code{Translator$t("translate me")}).
Find details in method descriptions below.
}
\examples{
\dontrun{
  i18n <- Translator$new(translation_json_path = "translation.json") # translation file
  i18n$set_translation_language("it")
  i18n$t("This text will be translated to Italian")
}

# Shiny example
if (interactive()) {
library(shiny)
library(shiny.i18n)
 #to run this example  make sure that you have a translation file
 #in the same path
i18n <- Translator$new(translation_json_path = "examples/data/translation.json")
i18n$set_translation_language("pl")
ui <- fluidPage(
  h2(i18n$t("Hello Shiny!"))
)
server <- function(input, output) {}
shinyApp(ui = ui, server = server)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Translator$new()}}
\item \href{#method-get_languages}{\code{Translator$get_languages()}}
\item \href{#method-get_translations}{\code{Translator$get_translations()}}
\item \href{#method-get_key_translation}{\code{Translator$get_key_translation()}}
\item \href{#method-translate}{\code{Translator$translate()}}
\item \href{#method-t}{\code{Translator$t()}}
\item \href{#method-set_translation_language}{\code{Translator$set_translation_language()}}
\item \href{#method-parse_date}{\code{Translator$parse_date()}}
\item \href{#method-parse_number}{\code{Translator$parse_number()}}
\item \href{#method-automatic_translate}{\code{Translator$automatic_translate()}}
\item \href{#method-at}{\code{Translator$at()}}
\item \href{#method-use_js}{\code{Translator$use_js()}}
\item \href{#method-clone}{\code{Translator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize the Translator with data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$new(
  translation_csvs_path = NULL,
  translation_json_path = NULL,
  translation_csv_config = NULL,
  separator_csv = ",",
  automatic = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{translation_csvs_path}}{character with path to folder containing csv
translation files. Files must have "translation_" prefix, for example:
\code{translation_<LANG-CODE>.csv}.}

\item{\code{translation_json_path}}{character with path to JSON translation file.
See more in  Details.}

\item{\code{translation_csv_config}}{character with path to configuration file for
csv option.}

\item{\code{separator_csv}}{separator of CSV values (default ",")}

\item{\code{automatic}}{logical flag, indicating if i18n should use an automatic
translation API.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_languages"></a>}}
\if{latex}{\out{\hypertarget{method-get_languages}{}}}
\subsection{Method \code{get_languages()}}{
Get all available languages
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$get_languages()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_translations"></a>}}
\if{latex}{\out{\hypertarget{method-get_translations}{}}}
\subsection{Method \code{get_translations()}}{
Get whole translation matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$get_translations()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_key_translation"></a>}}
\if{latex}{\out{\hypertarget{method-get_key_translation}{}}}
\subsection{Method \code{get_key_translation()}}{
Get active key translation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$get_key_translation()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-translate"></a>}}
\if{latex}{\out{\hypertarget{method-translate}{}}}
\subsection{Method \code{translate()}}{
Translates 'keyword' to language specified by 'set_translation_language'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$translate(keyword, session = shiny::getDefaultReactiveDomain())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keyword}}{character or vector of characters with a word or
expression to translate}

\item{\code{session}}{Shiny server session (default: current reactive domain)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-t"></a>}}
\if{latex}{\out{\hypertarget{method-t}{}}}
\subsection{Method \code{t()}}{
Wrapper to \code{translate} method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$t(keyword, session = shiny::getDefaultReactiveDomain())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keyword}}{character or vector of characters with a word or
expression to translate}

\item{\code{session}}{Shiny server session (default: current reactive domain)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_translation_language"></a>}}
\if{latex}{\out{\hypertarget{method-set_translation_language}{}}}
\subsection{Method \code{set_translation_language()}}{
Specify language of translation. It must exist in 'languages' field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$set_translation_language(transl_language)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transl_language}}{character with a translation language code}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parse_date"></a>}}
\if{latex}{\out{\hypertarget{method-parse_date}{}}}
\subsection{Method \code{parse_date()}}{
Parse date to format described in 'cultural_date_format' field in config.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$parse_date(date)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date}}{date object to format}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-parse_number"></a>}}
\if{latex}{\out{\hypertarget{method-parse_number}{}}}
\subsection{Method \code{parse_number()}}{
Numbers parser. Not implemented yet.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$parse_number(number)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{number}}{numeric or character with number}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
character with number formatting
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-automatic_translate"></a>}}
\if{latex}{\out{\hypertarget{method-automatic_translate}{}}}
\subsection{Method \code{automatic_translate()}}{
Translates 'keyword' to language specified by 'set_translation_language'
using cloud service 'api'. You need to set API settings first.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$automatic_translate(keyword, api = "google")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keyword}}{character or vector of characters with a word or
expression to translate}

\item{\code{api}}{character with the name of the API you want to use. Currently
supported: \code{google}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-at"></a>}}
\if{latex}{\out{\hypertarget{method-at}{}}}
\subsection{Method \code{at()}}{
Wrapper to \code{automatic_translate} method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$at(keyword, api = "google")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keyword}}{character or vector of characters with a word or
expression to translate}

\item{\code{api}}{character with the name of the API you want to use. Currently
supported: \code{google}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-use_js"></a>}}
\if{latex}{\out{\hypertarget{method-use_js}{}}}
\subsection{Method \code{use_js()}}{
Call to wrap translation in span object. Used for browser-side translations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$use_js()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
