% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactives.R
\name{freezeReactiveVal}
\alias{freezeReactiveVal}
\alias{freezeReactiveValue}
\title{Freeze a reactive value}
\usage{
freezeReactiveVal(x)

freezeReactiveValue(x, name)
}
\arguments{
\item{x}{For \code{freezeReactiveValue}, a \code{\link{reactiveValues}}
object (like \code{input}); for \code{freezeReactiveVal}, a
\code{\link{reactiveVal}} object.}

\item{name}{The name of a value in the \code{\link{reactiveValues}} object.}
}
\description{
These functions freeze a \code{\link{reactiveVal}}, or an element of a
\code{\link{reactiveValues}}. If the value is accessed while frozen, a
"silent" exception is raised and the operation is stopped. This is the same
thing that happens if \code{req(FALSE)} is called. The value is thawed
(un-frozen; accessing it will no longer raise an exception) when the current
reactive domain is flushed. In a Shiny application, this occurs after all of
the observers are executed.
}
\examples{
## Only run this examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  selectInput("data", "Data Set", c("mtcars", "pressure")),
  checkboxGroupInput("cols", "Columns (select 2)", character(0)),
  plotOutput("plot")
)

server <- function(input, output, session) {
  observe({
    data <- get(input$data)
    # Sets a flag on input$cols to essentially do req(FALSE) if input$cols
    # is accessed. Without this, an error will momentarily show whenever a
    # new data set is selected.
    freezeReactiveValue(input, "cols")
    updateCheckboxGroupInput(session, "cols", choices = names(data))
  })

  output$plot <- renderPlot({
    # When a new data set is selected, input$cols will have been invalidated
    # above, and this will essentially do the same as req(FALSE), causing
    # this observer to stop and raise a silent exception.
    cols <- input$cols
    data <- get(input$data)

    if (length(cols) == 2) {
      plot(data[[ cols[1] ]], data[[ cols[2] ]])
    }
  })
}

shinyApp(ui, server)
}
}
\seealso{
\code{\link{req}}
}
