% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{repeatable}
\alias{repeatable}
\title{Make a random number generator repeatable}
\usage{
repeatable(rngfunc, seed = stats::runif(1, 0, .Machine$integer.max))
}
\arguments{
\item{rngfunc}{The function that is affected by the R session's seed.}

\item{seed}{The seed to set every time the resulting function is called.}
}
\value{
A repeatable version of the function that was passed in.
}
\description{
Given a function that generates random data, returns a wrapped version of
that function that always uses the same seed when called. The seed to use can
be passed in explicitly if desired; otherwise, a random number is used.
}
\note{
When called, the returned function attempts to preserve the R session's
  current seed by snapshotting and restoring
  \code{\link[base]{.Random.seed}}.
}
\examples{
rnormA <- repeatable(rnorm)
rnormB <- repeatable(rnorm)
rnormA(3)  # [1]  1.8285879 -0.7468041 -0.4639111
rnormA(3)  # [1]  1.8285879 -0.7468041 -0.4639111
rnormA(5)  # [1]  1.8285879 -0.7468041 -0.4639111 -1.6510126 -1.4686924
rnormB(5)  # [1] -0.7946034  0.2568374 -0.6567597  1.2451387 -0.8375699
}
