% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renders.R, R/filter_discrete.R
\name{pre_post_stats}
\alias{pre_post_stats}
\alias{.pre_post_stats}
\alias{.pre_post_stats_text}
\title{Generate structure of pre/post statistics}
\usage{
.pre_post_stats(
  current,
  previous,
  name,
  brackets = FALSE,
  percent = FALSE,
  stats = c("pre", "post")
)

.pre_post_stats_text(
  current,
  previous,
  name,
  brackets = TRUE,
  percent = FALSE,
  stats = c("pre", "post")
)
}
\arguments{
\item{current}{Current step statistic value.}

\item{previous}{Previous step statistic value.}

\item{name}{Name displayed nearby the statistics output.}

\item{brackets}{If TRUE, statistics will be displayed in brackets.}

\item{percent}{Should current/previous ration in percentages be displayed?}

\item{stats}{Vector of "pre" and "post" defining which statistics should be returned.
"pre" for previous, "post" for current and NULL for none.}
}
\value{
A `shiny.tag` class `span` object defining html structure of data/value
  statistics, or character object.
}
\description{
The method exported only for custom extensions use.

`.pre_post_stats` returns the statistics having html tags structure.
`.pre_post_stats_text` returns the same output but flatten to a single character object.
The latter function works faster and supports vector arguments.
}
\examples{
.pre_post_stats(5, 10, "books")
.pre_post_stats_text(5, 10, "books")
.pre_post_stats(5, 10, "books", brackets = TRUE)
.pre_post_stats_text(5, 10, "books", brackets = TRUE)
.pre_post_stats(5, 10, "books", percent = TRUE)
.pre_post_stats_text(5, 10, "books", percent = TRUE)
.pre_post_stats_text(5:6, 10:11, "books", percent = TRUE)

}
