% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renders.R, R/filter_discrete.R,
%   R/filter_range.R, R/filter_date_range.R, R/filter_discrete_text.R,
%   R/filter_multi_discrete.R
\name{gui-filter-layer}
\alias{gui-filter-layer}
\alias{.gui_filter}
\alias{.gui_filter.discrete}
\alias{.gui_filter.range}
\alias{.gui_filter.date_range}
\alias{.gui_filter.discrete_text}
\alias{.gui_filter.multi_discrete}
\title{Return GUI layer methods for filter of specified type}
\usage{
.gui_filter(filter, ...)

\method{.gui_filter}{discrete}(filter, ...)

\method{.gui_filter}{range}(filter, ...)

\method{.gui_filter}{date_range}(filter, ...)

\method{.gui_filter}{discrete_text}(filter, ...)

\method{.gui_filter}{multi_discrete}(filter, ...)
}
\arguments{
\item{filter}{Filter object.}

\item{...}{Extra arguments passed to a specific method.}
}
\value{
List consisting filter metadata and methods that allow to perform filter based operations.
    See `vignette("custom-filters")`.
}
\description{
For each filter type `.gui_filter` method should return a list of the below objects:

\itemize{
  \item{input}{ UI structure defining filter input controllers.}
  \item{feedback}{ List defining feedback plot output.}
  \item{server}{ Optional server-side expression attached to filter panel (e.g. filter specific observers).}
  \item{update}{ An expression used for updating filter panel based on its configuration.}
  \item{post_stats}{ TRUE if post statistics are displayed in filter controller (e.g. for discrete filter).
    If FALSE, some operations are skipped which results with better performance.}
  \item{multi_input}{ TRUE if multiple input controllers are used for providing
    filter value (e.g. range input where both numericInput and sliderInput are used).
    If FALSE, some operations are skipped which results with better performance.
  }
}

If you want to learn more about creating filter layers see `vignette("gui-filter-layer")`.
}
\examples{
library(cohortBuilder)
librarian_source <- set_source(as.tblist(librarian))
copies_filter <- filter(
  "range", id = "copies", name = "Copies", dataset = "books",
  variable = "copies", range = c(5, 12)
)
copies_filter_evaled <- copies_filter(librarian_source)
copies_filter_evaled$gui <- .gui_filter(copies_filter_evaled)

str(copies_filter_evaled$gui)

}
\seealso{
\link{source-gui-layer}
}
