% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updatePlotlyH.R
\name{updatePlotlyH}
\alias{updatePlotlyH}
\title{Wrapper for updating plotly with huge data}
\usage{
updatePlotlyH(session, outputId, relayout_order, sd_obj)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}

\item{outputId}{Character. The outputId of the plotly that will be
down-sampled}

\item{relayout_order}{Named list.
The list is generated by converging the dictionary
obtained from \code{plotlyjs_relayout}.}

\item{sd_obj}{The \code{shiny_downsampler} instance that is used for
generating the figure and contains the full data.}
}
\description{
using this function, updater of the plotly with huge data is easily
installed.
}
\examples{
\donttest{
data(noise_fluct)
fig <- plot_ly(x = d$x, y = d$y, type = "scatter", mode = "lines")

shd <- shiny_downsampler$new(figure = fig)

ui <- fluidPage(
  plotlyOutput(outputId = "hp", width = "800px", height = "600px")
)

server <- function(input, output, session) {

  output$hp <- renderPlotly(shd$figure)

  observeEvent(plotly::event_data("plotly_relayout"),{
    updatePlotlyH(session, "hp", plotly::event_data("plotly_relayout"), shd)
  })

}

shinyApp(ui = ui, server = server)
}
}
