% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Accordion.R
\name{f7Accordion}
\alias{f7Accordion}
\title{Create a Framework7 accordion}
\usage{
f7Accordion(..., inputId = NULL, multiCollapse = FALSE)
}
\arguments{
\item{...}{Slot for \link{f7AccordionItem}.}

\item{inputId}{Optional id to recover the state of the accordion.}

\item{multiCollapse}{Whether to open multiple items at the same time. FALSE
by default.}
}
\description{
Build a Framework7 accordion
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
  ui = f7Page(
    title = "Accordions",
    f7SingleLayout(
     navbar = f7Navbar("Accordions"),
     f7Accordion(
      inputId = "myaccordion1",
      f7AccordionItem(
       title = "Item 1",
       f7Block("Item 1 content"),
       open = TRUE
      ),
      f7AccordionItem(
       title = "Item 2",
       f7Block("Item 2 content")
      )
     ),
     f7Accordion(
      multiCollapse = TRUE,
      inputId = "myaccordion2",
      f7AccordionItem(
       title = "Item 1",
       f7Block("Item 1 content")
      ),
      f7AccordionItem(
       title = "Item 2",
       f7Block("Item 2 content")
      )
     )
    )
  ),
  server = function(input, output, session) {
   observe({
    print(
     list(
      accordion1 = input$myaccordion1,
      accordion2 = input$myaccordion2
     )
    )
   })
  }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
