% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Page.R
\name{f7SingleLayout}
\alias{f7SingleLayout}
\title{Create a Framework7 single layout}
\usage{
f7SingleLayout(..., navbar, toolbar = NULL, panels = NULL, appbar = NULL)
}
\arguments{
\item{...}{Content.}

\item{navbar}{Slot for \link{f7Navbar}.}

\item{toolbar}{Slot for \link{f7Toolbar}.}

\item{panels}{Slot for \link{f7Panel}.
Wrap in \code{tagList} if multiple panels.}

\item{appbar}{Slot for \link{f7Appbar}.}
}
\description{
Build a Framework7 single layout
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)
 shiny::shinyApp(
  ui = f7Page(
    title = "My app",
    f7SingleLayout(
      navbar = f7Navbar(
        title = "Single Layout",
        hairline = FALSE,
        shadow = TRUE
      ),
      toolbar = f7Toolbar(
        position = "bottom",
        f7Link(label = "Link 1", src = "https://www.google.com"),
        f7Link(label = "Link 2", src = "https://www.google.com", external = TRUE)
      ),
      # main content
      f7Shadow(
        intensity = 10,
        hover = TRUE,
        f7Card(
          title = "Card header",
          f7Slider("obs", "Number of observations", 0, 1000, 500),
          plotOutput("distPlot"),
          footer = tagList(
            f7Button(color = "blue", label = "My button", src = "https://www.google.com"),
            f7Badge("Badge", color = "green")
          )
        )
      )
    )
  ),
  server = function(input, output) {
    output$distPlot <- renderPlot({
      dist <- rnorm(input$obs)
      hist(dist)
    })
  }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
