% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7TextArea}
\alias{f7TextArea}
\title{Create an f7 text area input}
\usage{
f7TextArea(inputId, label, value = "", placeholder = NULL, resize = FALSE)
}
\arguments{
\item{inputId}{Text input id.}

\item{label}{Text input label.}

\item{value}{Text input value.}

\item{placeholder}{Text input placeholder.}

\item{resize}{Whether to box can be resized. Default to FALSE.}
}
\description{
Create an f7 text area input
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
     title = "My app",
     f7TextArea(
      inputId = "textarea",
      label = "Text Area",
      value = "Lorem ipsum dolor sit amet, consectetur
       adipiscing elit, sed do eiusmod tempor incididunt ut
       labore et dolore magna aliqua",
      placeholder = "Your text here",
      resize = TRUE
     ),
     textOutput("value")
   ),
   server = function(input, output) {
     output$value <- renderText({ input$textarea })
   }
 )
}
}
