% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Fab.R
\name{f7Fab}
\alias{f7Fab}
\alias{updateF7Fab}
\title{Framework7 floating action button (FAB)}
\usage{
f7Fab(inputId, label, width = NULL, ..., flag = NULL)

updateF7Fab(inputId, label = NULL, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:reexports]{validateCssUnit()}}.}

\item{...}{Named attributes to be applied to the button or link.}

\item{flag}{Additional text displayed next to the button content. Only works
if \link{f7Fabs} position parameter is not starting with center-...}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
\link{f7Fab} generates a nice button to be put in \link{f7Fabs}.

\link{updateF7Fab} changes the label of a \link{f7Fab} input on the client.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 ui <- f7Page(
   f7SingleLayout(
    navbar = f7Navbar(title = "updateF7Fab"),
    f7Fab("trigger", "Click me")
   )
 )

 server <- function(input, output, session) {
   observeEvent(input$trigger, {
     updateF7Fab("trigger", label = "Don't click me")
   })
 }
shinyApp(ui, server)
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
