% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Navbar.R
\name{f7Navbar}
\alias{f7Navbar}
\alias{updateF7Navbar}
\title{Framework7 Navbar}
\usage{
f7Navbar(
  ...,
  subNavbar = NULL,
  title = NULL,
  subtitle = deprecated(),
  hairline = TRUE,
  shadow = deprecated(),
  bigger = FALSE,
  transparent = FALSE,
  leftPanel = FALSE,
  rightPanel = FALSE
)

updateF7Navbar(
  animate = TRUE,
  hideStatusbar = FALSE,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{...}{Slot for \link{f7SearchbarTrigger}. Not compatible with \link{f7Panel}.}

\item{subNavbar}{\link{f7SubNavbar} slot, if any.}

\item{title}{Navbar title.}

\item{subtitle}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
removed from Framework7.}

\item{hairline}{Whether to display a thin border on the top of the navbar. TRUE by default,
for ios.}

\item{shadow}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}:
removed from Framework7.}

\item{bigger}{Whether to display bigger title. FALSE by default. Title
becomes smaller when scrolling down the page.}

\item{transparent}{Whether the navbar should be transparent. FALSE by default.
Only works if bigger is TRUE.}

\item{leftPanel}{Whether to enable the left panel. FALSE by default.
You can also pass a list of shiny tag with \code{shiny::tagList}, such as an icon or text. This is useful
when using the yet experimental routable API with \link{f7MultiLayout}.}

\item{rightPanel}{Whether to enable the right panel. FALSE by default.
You can also pass a list of shiny tags with \code{shiny::tagList}, such as an icon or text. This is useful
when using the yet experimental routable API with \link{f7MultiLayout}.}

\item{animate}{Whether it should be hidden with animation or not. By default is TRUE.}

\item{hideStatusbar}{When FALSE (default) it hides navbar partially keeping space
required to cover statusbar area. Otherwise, navbar will be fully hidden.}

\item{session}{Shiny session object.}
}
\description{
Build a navbar layout element to insert in \link{f7SingleLayout},
\link{f7TabLayout} or \link{f7SplitLayout}.

\code{updateF7Navbar} toggles an \link{f7Navbar} component from the server.
}
\note{
Currently, bigger parameters does mess with the CSS.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "Sub Navbar",
    options = list(
      dark = FALSE,
      navbar = list(
        hideOnPageScroll = TRUE,
        mdCenterTitle = TRUE
      )
    ),
    f7SingleLayout(
      panels = tagList(
        f7Panel(
          title = "Left Panel",
          side = "left",
          f7Block("Blabla"),
          effect = "cover"
        ),
        f7Panel(
          title = "Right Panel",
          side = "right",
          f7Block("Blabla"),
          effect = "cover"
        )
      ),
      navbar = f7Navbar(
        subNavbar = f7SubNavbar(
          f7Button(label = "My button"),
          f7Button(label = "My button"),
          f7Button(label = "My button")
        ),
        title = "Title",
        leftPanel = TRUE,
        rightPanel = TRUE
      ),
      f7Block(f7Button(inputId = "toggle", "Toggle navbar")),
      f7Block(
        lapply(1:20, f7Card)
      )
    )
  ),
  server = function(input, output, session) {
    observeEvent(input$toggle, {
      updateF7Navbar()
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
