% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweetalert.R
\name{sweetalert-confirmation}
\alias{sweetalert-confirmation}
\alias{confirmSweetAlert}
\alias{ask_confirmation}
\title{Launch a confirmation dialog}
\usage{
confirmSweetAlert(
  session,
  inputId,
  title = NULL,
  text = NULL,
  type = "question",
  btn_labels = c("Cancel", "Confirm"),
  btn_colors = NULL,
  closeOnClickOutside = FALSE,
  showCloseButton = FALSE,
  html = FALSE,
  ...
)

ask_confirmation(
  inputId,
  title = NULL,
  text = NULL,
  type = "question",
  btn_labels = c("Cancel", "Confirm"),
  btn_colors = NULL,
  closeOnClickOutside = FALSE,
  showCloseButton = FALSE,
  html = FALSE,
  ...,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to shinyServer.}

\item{inputId}{The \code{input} slot that will be used to access the value.
If in a Shiny module, it use same logic than inputs : use namespace in UI, not in server.}

\item{title}{Title of the alert.}

\item{text}{Text of the alert, can contains HTML tags.}

\item{type}{Type of the alert : info, success, warning or error.}

\item{btn_labels}{Labels for buttons, cancel button (\code{FALSE}) first then confirm button (\code{TRUE}).}

\item{btn_colors}{Colors for buttons.}

\item{closeOnClickOutside}{Decide whether the user should be able to dismiss
the modal by clicking outside of it, or not.}

\item{showCloseButton}{Show close button in top right corner of the modal.}

\item{html}{Does \code{text} contains HTML tags ?}

\item{...}{Additional arguments (not used)}
}
\description{
Launch a popup to ask the user for confirmation.
}
\examples{
library(shiny)
library(shinyWidgets)


ui <- fluidPage(
  tags$h1("Ask the user for confirmation"),
  actionButton(
    inputId = "launch",
    label = "Ask for confirmation"
  ),
  verbatimTextOutput(outputId = "res"),
  uiOutput(outputId = "count")
)

server <- function(input, output, session) {

  # Launch sweet alert confirmation
  observeEvent(input$launch, {
    ask_confirmation(
      inputId = "myconfirmation",
      title = "Want to confirm ?"
    )
  })

  # raw output
  output$res <- renderPrint(input$myconfirmation)

  # count click
  true <- reactiveVal(0)
  false <- reactiveVal(0)
  observeEvent(input$myconfirmation, {
    if (isTRUE(input$myconfirmation)) {
      x <- true() + 1
      true(x)
    } else {
      x <- false() + 1
      false(x)
    }
  }, ignoreNULL = TRUE)

  output$count <- renderUI({
    tags$span(
      "Confirm:", tags$b(true()),
      tags$br(),
      "Cancel:", tags$b(false())
    )
  })
}

if (interactive())
  shinyApp(ui, server)

# ------------------------------------
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h1("Ask for confirmation"),
  actionButton(
    inputId = "launch1",
    label = "Launch confirmation dialog"
  ),
  verbatimTextOutput(outputId = "res1"),
  tags$br(),
  actionButton(
    inputId = "launch2",
    label = "Launch confirmation dialog (with normal mode)"
  ),
  verbatimTextOutput(outputId = "res2"),
  tags$br(),
  actionButton(
    inputId = "launch3",
    label = "Launch confirmation dialog (with HTML)"
  ),
  verbatimTextOutput(outputId = "res3")
)

server <- function(input, output, session) {

  observeEvent(input$launch1, {
    ask_confirmation(
      inputId = "myconfirmation1",
      type = "warning",
      title = "Want to confirm ?"
    )
  })
  output$res1 <- renderPrint(input$myconfirmation1)

  observeEvent(input$launch2, {
    ask_confirmation(
      inputId = "myconfirmation2",
      type = "warning",
      title = "Are you sure ??",
      btn_labels = c("Nope", "Yep"),
      btn_colors = c("#FE642E", "#04B404")
    )
  })
  output$res2 <- renderPrint(input$myconfirmation2)

  observeEvent(input$launch3, {
    ask_confirmation(
      inputId = "myconfirmation3",
      title = NULL,
      text = tags$b(
        icon("file"),
        "Do you really want to delete this file ?",
        style = "color: #FA5858;"
      ),
      btn_labels = c("Cancel", "Delete file"),
      btn_colors = c("#00BFFF", "#FE2E2E"),
      html = TRUE
    )
  })
  output$res3 <- renderPrint(input$myconfirmation3)

}

if (interactive())
  shinyApp(ui, server)
}
\seealso{
\code{\link{sendSweetAlert}}, \code{\link{inputSweetAlert}},
 \code{\link{closeSweetAlert}}.
}
