% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop-menu.R
\name{drop-menu-interaction}
\alias{drop-menu-interaction}
\alias{enableDropMenu}
\alias{disableDropMenu}
\alias{showDropMenu}
\alias{hideDropMenu}
\title{Interact with Drop Menu}
\usage{
enableDropMenu(id, session = shiny::getDefaultReactiveDomain())

disableDropMenu(id, session = shiny::getDefaultReactiveDomain())

showDropMenu(id, session = shiny::getDefaultReactiveDomain())

hideDropMenu(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{id}{Drop menu ID, the \code{tag}'s ID followed by \code{"_dropmenu"}.}

\item{session}{Shiny session.}
}
\description{
Interact with Drop Menu
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(
    tags$h2("Drop Menu interactions"),
    dropMenu(
      actionButton("myid", "See what's inside"),
      "Drop menu content",
      actionButton("hide", "Close menu"),
      position = "right middle"
    ),
    tags$br(),
    tags$p("Is drop menu opened?"),
    verbatimTextOutput("isOpen"),
    actionButton("show", "show menu"),
    tags$br(),
    tags$br(),
    dropMenu(
      actionButton("dontclose", "Only closeable from server"),
      "Drop menu content",
      actionButton("close", "Close menu"),
      position = "right middle",
      hideOnClick = FALSE
    )
  )

  server <- function(input, output, session) {

    output$isOpen <- renderPrint({
      input$myid_dropmenu
    })

    observeEvent(input$show, {
      showDropMenu("myid_dropmenu")
    })

    observeEvent(input$hide, {
      hideDropMenu("myid_dropmenu")
    })

    observeEvent(input$close, {
      hideDropMenu("dontclose_dropmenu")
    })

  }

  shinyApp(ui, server)
}
}
