% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-materialswitch.R
\name{materialSwitch}
\alias{materialSwitch}
\title{Material Design Switch Input Control}
\usage{
materialSwitch(
  inputId,
  label = NULL,
  value = FALSE,
  status = "default",
  right = FALSE,
  inline = FALSE,
  width = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Input label.}

\item{value}{TRUE or FALSE.}

\item{status}{Color, must be a valid Bootstrap status : default, primary, info, success, warning, danger.}

\item{right}{Should the the label be on the right? default to FALSE.}

\item{inline}{Display the input inline, if you want to place buttons next to each other.}

\item{width}{The width of the input, e.g. \verb{400px}, or \verb{100\%}.}
}
\value{
A switch control that can be added to a UI definition.
}
\description{
A toggle switch to turn a selection on or off.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyWidgets)

  ui <- fluidPage(
    tags$h3("Material switch examples"),

    materialSwitch(inputId = "switch1", label = "Night mode"),
    verbatimTextOutput("value1"),

    materialSwitch(inputId = "switch2", label = "Night mode", status = "danger"),
    verbatimTextOutput("value2")
  )
  server <- function(input, output) {

    output$value1 <- renderText({ input$switch1 })

    output$value2 <- renderText({ input$switch2 })

  }
  shinyApp(ui, server)
}

}
\seealso{
\code{\link{updateMaterialSwitch}}, \code{\link{switchInput}}
}
