% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/displacement_plot.R
\name{displacement_plot}
\alias{displacement_plot}
\title{Plot shoreline displacement curves}
\usage{
displacement_plot(
  interpolated_curve = NA,
  displacement_curves = c("Horten", "Porsgrunn", "Tvedestrand", "Arendal"),
  greyscale = FALSE
)
}
\arguments{
\item{interpolated_curve}{List holding one or more interpolated shoreline
displacement curves.}

\item{displacement_curves}{Character vector specifying which geologically
informed displacement curves that should be plotted. Accepted values are
\code{c("Horten", "Porsgrunn", "Tvedestrand", "Arendal")}. All are included by
default.}

\item{greyscale}{Logical value indicating whether the plot should be in
greyscale or not. Defaults to FALSE.}
}
\value{
A plot displaying the underlying shoreline displacement curves and,
if provided, an interpolated curve.
}
\description{
Function for plotting shoreline displacement curves. Calling to plot without
providing interpolated curves will display the four underlying curves.
}
\examples{
\dontrun{
# Plot the geologically derived displacement curves
displacement_plot()
}
}
