% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-timing-gates-splits.R
\name{create_timing_gates_splits}
\alias{create_timing_gates_splits}
\title{Create Timing Gates Splits}
\usage{
create_timing_gates_splits(
  MSS,
  MAC,
  gates = c(5, 10, 20, 30, 40),
  FD = 0,
  TC = 0,
  noise = 0
)
}
\arguments{
\item{MSS, MAC}{Numeric vectors. Model parameters}

\item{gates}{Numeric vectors. Distances of the timing gates}

\item{FD}{Numeric vector. Flying start distance. Default is 0}

\item{TC}{Numeric vector. Time-correction added to split times (e.g., reaction time). Default is 0}

\item{noise}{Numeric vector. SD of Gaussian noise added to the split times. Default is 0}
}
\description{
This function is used to generate timing gates splits with predetermined parameters
}
\examples{
create_timing_gates_splits(
  gates = c(10, 20, 30, 40, 50),
  MSS = 10,
  MAC = 9,
  FD = 0.5,
  TC = 0
)
}
