% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_series.R
\name{draw_cn_components}
\alias{draw_cn_components}
\title{Plot mixture fit model components}
\usage{
draw_cn_components(features, components, ...)
}
\arguments{
\item{features}{a \code{list} generate from \link{get_features} or \link{sig_prepare} function.}

\item{components}{a \code{list} contain flexmix object of copy-number features, obtain this
from \link{get_components} function or use pre-compiled components data which come from CNV signature paper
\url{https://www.nature.com/articles/s41588-018-0179-8} (set this argument as \code{NULL}).}

\item{...}{other options pass to \code{\link[cowplot]{plot_grid}} function of \strong{cowplot} package.}
}
\value{
a ggplot object
}
\description{
Plot mixture fit model components
}
\examples{
# Load copy number prepare object
load(system.file("extdata", "toy_copynumber_prepare.RData",
  package = "sigminer", mustWork = TRUE
))
draw_cn_components(cn_prepare$features, cn_prepare$components)
}
\seealso{
Other copy number plot: \code{\link{draw_cn_distribution}},
  \code{\link{draw_cn_features}}
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
\concept{copy number plot}
