% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signature_series.R
\name{sig_summarize_subtypes}
\alias{sig_summarize_subtypes}
\title{Get summary of signature subtypes}
\usage{
sig_summarize_subtypes(data, col_subtype, cols_to_summary, type = "ca",
  verbose = FALSE)
}
\arguments{
\item{data}{a \code{data.frame} contains signature subtypes and genotypes/phenotypes
(including categorical and continuous type data) want to analyze. User need to
construct this \code{data.frame} by him/herself.}

\item{col_subtype}{column name of signature subtypes.}

\item{cols_to_summary}{column names of genotypes/phenotypes want to summarize based on subtypes.}

\item{type}{a characater vector with length same as \code{cols_to_summary},
'ca' for categorical type and 'co' for continuous type.}

\item{verbose}{if \code{TRUE}, print extra information.}
}
\value{
a \code{list} contains data, summary, p value etc..
}
\description{
Summarize genotypes/phenotypes based on signature subtypes. For categorical
type, calculate fisher p value (using \link[stats:fisher.test]{stats::fisher.test}) and count table.
For continuous type, calculate anova p value (using \link[stats:aov]{stats::aov}),
summary table and Tukey Honest significant difference (using \link[stats:TukeyHSD]{stats::TukeyHSD}).
The result of this function can be plotted by \code{\link[=draw_subtypes_comparison]{draw_subtypes_comparison()}}.
}
\examples{
# Load copy number signature
load(system.file("extdata", "toy_copynumber_signature.RData",
  package = "sigminer", mustWork = TRUE
))
# Assign samples to clusters
subtypes <- sig_assign_samples(res$nmfObj, type = "samples")

set.seed(1234)
# Add custom groups
subtypes$new_group <- sample(c("1", "2", "3", "4"), size = nrow(subtypes), replace = TRUE)
# Summarize subtypes
subtypes.sum <- sig_summarize_subtypes(subtypes[, -1],
  col_subtype = "nmf_subtypes",
  cols_to_summary = colnames(subtypes[, -1])[c(-1, -2)],
  type = c("co", "ca"), verbose = TRUE
)
}
\seealso{
Other signature analysis series function: \code{\link{sig_assign_samples}},
  \code{\link{sig_estimate}}, \code{\link{sig_extract}},
  \code{\link{sig_get_activity}},
  \code{\link{sig_get_correlation}},
  \code{\link{sig_get_similarity}},
  \code{\link{sig_prepare}}
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
\concept{signature analysis series function}
