% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigprofiler.R
\name{sigprofiler}
\alias{sigprofiler}
\alias{sigprofiler_extract}
\alias{sigprofiler_import}
\title{Extract Signatures with SigProfiler}
\usage{
sigprofiler_extract(
  nmf_matrix,
  output,
  range = 2:5,
  nrun = 10L,
  is_exome = TRUE,
  init_method = c("random", "alexandrov-lab-custom", "nndsvd", "nndsvda", "nndsvdar"),
  cores = -1L,
  genome_build = c("hg19", "hg38", "mm10"),
  use_conda = FALSE,
  py_path = NULL,
  sigprofiler_version = "1.0.17"
)

sigprofiler_import(output, type = c("suggest", "all"))
}
\arguments{
\item{nmf_matrix}{a \code{matrix} used for NMF decomposition with rows indicate samples and columns indicate components.}

\item{output}{output directory.}

\item{range}{signature number range, i.e. \code{2:5}.}

\item{nrun}{the number of iteration to be performed to extract each signature number.}

\item{is_exome}{if \code{TRUE}, the exomes will be extracted.}

\item{init_method}{the initialization algorithm for W and H matrix of NMF.
Options are 'random', 'nndsvd', 'nndsvda', 'nndsvdar' and 'alexandrov-lab-custom'.}

\item{cores}{number of cores used for computation.}

\item{genome_build}{I think this option is useless when input is \code{matrix}, keep it
in case it is useful.}

\item{use_conda}{if \code{TRUE}, create an independent conda environment to run SigProfiler.}

\item{py_path}{path to Python executable file, e.g. '/Users/wsx/anaconda3/bin/python'.}

\item{sigprofiler_version}{version of \code{SigProfilerExtractor}.}

\item{type}{one of 'suggest' (for suggested solution) or 'all' (for all solutions).}
}
\value{
For \code{sigprofiler_extract()}, returns nothing. See \code{output} directory.

For \code{sigprofiler_import()}, a \code{list} containing \code{Signature} object.
}
\description{
This function provides an interface to software SigProfiler.
More please see \url{https://github.com/AlexandrovLab/SigProfilerExtractor}.
Typically, a reference genome is not required because the input is a matrix (my understanding).
}
\examples{
if (FALSE) {
  load(system.file("extdata", "toy_copynumber_tally_M.RData",
    package = "sigminer", mustWork = TRUE
  ))

  reticulate::conda_list()

  sigprofiler_extract(cn_tally_M$nmf_matrix, "~/test/test_sigminer",
    use_conda = TRUE
  )

  sigprofiler_extract(cn_tally_M$nmf_matrix, "~/test/test_sigminer",
    use_conda = FALSE, py_path = "/Users/wsx/anaconda3/bin/python"
  )
}
}
