% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_sig_feature_corrplot.R
\name{show_sig_feature_corrplot}
\alias{show_sig_feature_corrplot}
\title{Draw Corrplot for Signature Exposures and Other Features}
\usage{
show_sig_feature_corrplot(
  tidy_cor,
  feature_list,
  sort_features = FALSE,
  drop = TRUE,
  return_plotlist = FALSE,
  p_val = 0.05,
  xlab = "Signatures",
  ylab = "Features",
  co_gradient_colors = scale_color_gradient2(low = "blue", mid = "white", high = "red",
    midpoint = 0),
  ca_gradient_colors = co_gradient_colors,
  plot_ratio = "auto",
  breaks_count = c(0L, 200L, 400L, 600L, 800L, 1020L)
)
}
\arguments{
\item{tidy_cor}{data returned by \link{get_tidy_association}.}

\item{feature_list}{a character vector contains features want to be plotted.
If missing, all features will be used.}

\item{sort_features}{default is \code{FALSE}, use feature order obtained from the previous
step. If \code{TRUE}, sort features as \code{feature_list}.}

\item{drop}{if \code{TRUE}, when a feature has no association with all signatures
(p value larger than threshold set by \code{p_val}), this feature will be removed
from the plot. Otherwise, this feature (a row) will keep with all blank white.}

\item{return_plotlist}{if \code{TRUE}, return as a list of \code{ggplot} objects.}

\item{p_val}{p value threshold. If p value larger than this threshold,
the result becomes blank white.}

\item{xlab}{label for x axis.}

\item{ylab}{label for y axis.}

\item{co_gradient_colors}{a Scale object representing gradient colors used to plot for continuous features.}

\item{ca_gradient_colors}{a Scale object representing gradient colors used to plot for categorical features.}

\item{plot_ratio}{a length-2 numeric vector to set the height/width ratio.}

\item{breaks_count}{breaks for sample count. If set it to \code{NULL},
ggplot \code{bin} scale will be used to automatically determine the
breaks. If set it to \code{NA}, \code{aes} for sample will be not used.}
}
\value{
a \code{ggplot2} object
}
\description{
This function is for association visualization. Of note,
the parameters \code{p_val} and \code{drop} will affect the visualization
of association results under p value threshold.
}
\examples{

# The data is generated from Wang, Shixiang et al.
load(system.file("extdata", "asso_data.RData",
  package = "sigminer", mustWork = TRUE
))

p <- show_sig_feature_corrplot(tidy_data.seqz.feature, p_val = 0.05)
p
}
\seealso{
\link{get_tidy_association} and \link{get_sig_feature_association}
}
