% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomass.R
\name{silv_biomass}
\alias{silv_biomass}
\title{Calculate Tree Biomass}
\usage{
silv_biomass(
  diameter = NULL,
  height = NULL,
  ntrees = NULL,
  species = NULL,
  component = "stem",
  model = "ruiz-peinado-2012",
  return_rmse = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{diameter}{A numeric vector of tree diameters (in cm).}

\item{height}{A numeric vector of tree heights (in m).}

\item{ntrees}{An optional numeric value indicating the number of trees in
this diameter-height class. Defaults to 1 if NULL.}

\item{species}{A character string specifying the scientific name of the tree
species. See Details for available species.}

\item{component}{A character string specifying the tree component for biomass
calculation (e.g., "tree", "stem", "branches"). See Details.}

\item{model}{A character string indicating the ID of the publication in which
the model was developed. Currently supported models: "ruiz-peinado-2012"
(hardwood species in Spain) and "ruiz-peinado-2011" (softwood species in
Spain). See Details.}

\item{return_rmse}{A logical value. If TRUE, the function returns the root
mean squared error (RMSE) of the selected model instead of the biomass value.}

\item{quiet}{A logical value. If TRUE, suppresses any informational messages.}
}
\value{
A numeric vector of biomass values (in kg). If \code{return_rmse = TRUE}, returns the RMSE instead.
}
\description{
Computes the biomass of a tree species using species-specific allometric
equations (in kg).
}
\details{
The function estimates biomass using validated allometric models available in the
dataset \link{biomass_models}. The available models include:
\itemize{
\item \strong{ruiz-peinado-2011}: Developed for softwood species in Spain.
\item \strong{ruiz-peinado-2012}: Developed for hardwood species in Spain.
}

Users can check the list of supported species and their corresponding components
in \link{biomass_models}.

If you would like to suggest additional models, please open a new issue on GitHub.
}
\examples{
# Calculate biomass for a single tree
silv_biomass(
  diameter = 45,
  height   = 22,
  species  = "Pinus pinaster",
  model    = "ruiz-peinado-2011"
)
}
