% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{generateUnrelatedIndividuals}
\alias{generateUnrelatedIndividuals}
\title{Generates variant data for n unrelated individuals}
\usage{
generateUnrelatedIndividuals(N = 1)
}
\arguments{
\item{N}{how many individuals to generate}
}
\value{
IDs of the generated individuals
}
\description{
Generates variant data for n unrelated individuals
}
\examples{

library("sim1000G")

examples_dir = system.file("examples", package = "sim1000G")
vcf_file = file.path(examples_dir, "region.vcf.gz")
vcf = readVCF( vcf_file, maxNumberOfVariants = 100 , min_maf = 0.12)

genetic_map_of_region =
   system.file("examples",
     "chr4-geneticmap.txt",
     package = "sim1000G")

readGeneticMapFromFile(genetic_map_of_region)

startSimulation(vcf, totalNumberOfIndividuals = 1200)
ids = generateUnrelatedIndividuals(20)

# See also the documentation on our github page

}
