% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_meteorlogy.R
\name{cal_relativeHumidity}
\alias{cal_relativeHumidity}
\title{Calculating relative humidity}
\usage{
cal_relativeHumidity(ea, e0)
}
\arguments{
\item{ea}{actual saturation vapour pressure. From cal_ActualVapourPressure_for_*}

\item{e0}{saturation vapour pressure. From cal_saturationVapourPressure()}
}
\value{
A vector for relative humidity \%
}
\description{
The relative humidity (RH) expresses the degree of saturation of
   the air as a ratio of the actual (ea) to the saturation (eo(T)) vapour
   pressure at the same temperature (T).
}
\details{
Relative humidity is the ratio between the amount of water the ambient
   air actually holds and the amount it could hold at the same temperature.
   It is dimensionless and is commonly given as a percentage. Although the
   actual vapour pressure might be relatively constant throughout the day,
   the relative humidity fluctuates between a maximum near sunrise and a
   minimum around early afternoon (Figure 12). The variation of the relative
   humidity is the result of the fact that the saturation vapour pressure is
   determined by the air temperature. As the temperature changes during the
    day, the relative humidity also changes substantially.
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M.
   FAO Irrigation and drainage paper No. 56. Rome: Food and Agriculture
   Organization of the United Nations, 1998.
}
