% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transitionParameters.R
\name{piecewise_exponential}
\alias{piecewise_exponential}
\title{Transition Hazards for Piecewise Exponential Event Times}
\usage{
piecewise_exponential(h01, h02, h12, pw01, pw02, pw12)
}
\arguments{
\item{h01}{(\verb{numeric vector})\cr constant transition hazards for 0 to 1 transition}

\item{h02}{(\verb{numeric vector})\cr  constant transition hazards for 0 to 2 transition}

\item{h12}{(\verb{numeric vector})\cr  constant transition hazards for 1 to 2 transition}

\item{pw01}{(\verb{numeric vector})\cr time intervals for the piecewise constant hazards \code{h01}}

\item{pw02}{(\verb{numeric vector})\cr time intervals for the piecewise constant hazards \code{h02}}

\item{pw12}{(\verb{numeric vector})\cr  time intervals for the piecewise constant hazards \code{h12}}
}
\value{
List with elements \code{hazards}, \code{intervals}, \code{weibull_rates} and \code{family}
(piecewise exponential).
}
\description{
This creates a list with class \code{TransitionParameters} containing
hazards, time intervals and Weibull rates for piecewise exponential event times
in an illness-death model.
}
\examples{
piecewise_exponential(
  h01 = c(1, 1, 1), h02 = c(1.5, 0.5, 1), h12 = c(1, 1, 1),
  pw01 = c(0, 3, 8), pw02 = c(0, 6, 7), pw12 = c(0, 8, 9)
)
}
