% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ITSModelingCode.R
\name{smooth_series}
\alias{smooth_series}
\title{Smooth a series using a static loess smoother}
\usage{
smooth_series(res, outcomename, t0, smooth_k = SMOOTH_K, post.only = TRUE, ...)
}
\arguments{
\item{res}{A dataframe with a month column and an 'outcomename' column (which
is the column that will be smoothed).}

\item{outcomename}{String name of the outcome variable in dat.}

\item{t0}{last pre-policy timepoint}

\item{smooth_k}{A rough proxy for the number of observations to primarily
consider to kernal weight in the neighborhood of each timepoint (this is a
bandwidth, and the loess smoother gets smooth_k / n as a span value).  We
want to smooth with an absolute bandwidth, not one as function of how long
the time series is.}

\item{post.only}{If TRUE fit model and smooth post-policy only. WHY fit model
on post-policy data only?  Because this will make sure the fixed pre-policy
does not dominate too much?  We are focusing on post-policy so we want a
good fitting model for that so we can get our residuals as "white noise" as
possible before smoothing.}

\item{...}{Extra arguments (not used in this function).}
}
\value{
An updated version of the 'res' dataframe with `Ysmooth`, the
  smoothed predictions of the original Ystar outcome.  Also includes 'Ystar'
  the original sequence to be smoothed.
}
\description{
Use loess smoother on complete series of residuals including original data
pre-policy and synthetic data post policy (i.e., smooth the entire plausible
series).
}
\details{
This method takes several parameters it does not use, to maintain
compatability with smooth_residuals.
}
\examples{

data( "newjersey" )
smooth = smooth_series( newjersey, outcomename = "n.warrant", t0= -8,
                        smooth_k = 30,
                        post.only = FALSE)
plot( newjersey$month, newjersey$n.warrant )
lines( newjersey$month, smooth, col="red" )  

mod =  make_fit_season_model( ~ temperature )
newjersey = add_lagged_covariates( newjersey, outcomename = "n.warrant", 
                                   covariates = c("temperature") )

smooth = smooth_residuals( newjersey, outcomename = "n.warrant", t0=-8,
                           smooth_k = 30,
                           post.only = FALSE,
                           fit_model = mod )
plot( newjersey$month, newjersey$n.warrant )
lines( newjersey$month, smooth, col="red" )  
}
