% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spMosaic.R
\name{spMosaic}
\alias{spMosaic}
\title{Mosaic plots of expected and realized population sizes}
\usage{
spMosaic(x, method = c("split", "color"), ...)
}
\arguments{
\item{x}{An object of class \code{"spTable"} created using function
\code{\link{spTable}}.}

\item{method}{A character string specifying the plot method. Possible values
are \code{"split"} to plot the expected population sizes on the left hand
side and the realized population sizes on the right hand side, and
\code{"color"}}

\item{\dots}{if \code{method} is \code{"split"}, further arguments to be
passed to \code{\link[vcd]{cotabplot}}.  If \code{method} is \code{"color"},
further arguments to be passed to \code{\link[vcd]{strucplot}}}
}
\description{
Create mosaic plots of expected (i.e., estimated) and realized (i.e.,
simulated) population sizes.
}
\details{
If \code{method} is \code{"split"}, the two tables of expected and realized
population sizes are combined into a single table, with an additional
conditioning variable indicating expected and realized values. A conditional
plot of this table is then produced using \code{\link[vcd]{cotabplot}}.
}
\examples{
set.seed(1234)  # for reproducibility
data(eusilcS)   # load sample data
samp <- specifyInput(data=eusilcS, hhid="db030", hhsize="hsize",
  strata="db040", weight="db090")
eusilcP <- simStructure(data=samp, method="direct", basicHHvars=c("age","rb090"))
abb <- c("B","LA","Vi","C","St","UA","Sa","T","Vo")
tab <- spTable(eusilcP, select=c("rb090", "db040", "hsize"))

# expected and realized population sizes
spMosaic(tab, method = "split",
  labeling=labeling_border(abbreviate=c(db040=TRUE)))

# realized population sizes colored according to relative
# differences with expected population sizes
spMosaic(tab, method = "color",
  labeling=labeling_border(abbreviate=c(db040=TRUE)))

}
\author{
Andreas Alfons and Bernhard Meindl
}
\seealso{
\code{\link{spTable}}, \code{\link[vcd]{cotabplot}},
\code{\link[vcd]{strucplot}}
}
\keyword{hplot}

