% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/spBwplotStats.R
\name{spBwplotStats}
\alias{spBwplotStats}
\title{Weighted box plot statistics}
\usage{
spBwplotStats(x, weights = NULL, coef = 1.5, zeros = TRUE,
  do.out = TRUE)
}
\arguments{
\item{x}{a numeric vector.}

\item{weights}{an optional numeric vector containing sample weights.}

\item{coef}{a numeric value that determines the extension of the whiskers.}

\item{zeros}{a logical indicating whether the variable specified by
\code{additional} is semi-continuous, i.e., contains a considerable amount
of zeros.  If \code{TRUE}, the (weighted) box plot statistics are computed
for the non-zero data points only and the number of zeros is returned, too.}

\item{do.out}{a logical indicating whether data points that lie beyond the
extremes of the whiskers should be returned.}
}
\value{
A list of class \code{"spBwplotStats"} with the following
components: \item{stats}{A vector of length 5 containing the (weighted)
statistics for the construction of a box plot.} \item{n}{if \code{weights}
is \code{NULL}, the number of non-missing and, if \code{zeros} is
\code{TRUE}, non-zero data points.  Otherwise the sum of the weights of the
corresponding points.} \item{nzero}{if \code{zeros} is \code{TRUE} and
\code{weights} is \code{NULL}, the number of zeros.  If \code{zeros} is
\code{TRUE} and \code{weights} is not \code{NULL}, the sum of the weights of
the zeros.  If \code{zeros} is not \code{TRUE}, this is \code{NULL}.}
\item{out}{if \code{do.out}, the values of any data points that lie beyond
the extremes of the whiskers.}
}
\description{
Compute the statistics necessary for producing box-and-whisker plots of
continuous or semi-continuous variables, taking into account sample weights.
}
\details{
The function \code{\link{quantileWt}} is used for the computation of
(weighted) quantiles.  The median is computed together with the first and
the third quartile, which form the box.  If \code{range} is positive, the
whiskers extend to the most extreme data points that have a distance to the
box of no more than \code{coef} times the interquartile range.  For
\code{coef = 0}, the whiskers mark the minimum and the maximum of the
sample, whereas a negative value causes an error.
}
\examples{
data(eusilcS)

## semi-continuous variable
spBwplotStats(eusilcS$netIncome,
    weights=eusilcS$rb050, do.out = FALSE)
}
\author{
Stefan Kraft and Andreas Alfons
}
\seealso{
\code{\link{spBwplot}}, for producing (weighted) box plots of
continuous or semi-continuous variables.

\code{\link{quantileWt}} for the computation of (weighted) sample quantiles.

\code{\link[grDevices]{boxplot.stats}} for the unweighted statistics for box
plots (not considering semi-continuous variables).
}
\keyword{dplot}

