% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addWeights.r
\name{addWeights<-}
\alias{addWeights<-}
\alias{addWeights}
\alias{addWeights<-,dataObj-method}
\alias{addWeights<-,simPopObj-method}
\title{Methods for function \code{addWeights}}
\usage{
addWeights(object) <- value

\S4method{addWeights}{dataObj}(object) <- value

\S4method{addWeights}{simPopObj}(object) <- value
}
\arguments{
\item{object}{an object of class \code{\linkS4class{dataObj}} or \code{\linkS4class{simPopObj}}.}

\item{value}{a numeric vector of suitable length}
}
\description{
allows to modify sampling weights of an \code{\linkS4class{dataObj}} or
\code{\linkS4class{simPopObj}}-object. As input the output of
\code{\link{calibSample}} must be used.
}
\examples{
data(eusilcS)
data(totalsRG)
inp <- specifyInput(data=eusilcS, hhid="db030", hhsize="hsize", strata="db040", weight="db090")
\donttest{
## approx. 20 seconds ...
addWeights(inp) <- calibSample(inp, totalsRG)
}
}
