% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simStateSpace-lin-sde-cov.R
\name{LinSDECov}
\alias{LinSDECov}
\title{Steady-State Covariance Matrix for the
Linear Stochastic Differential Equation Model}
\usage{
LinSDECov(phi, sigma)
}
\arguments{
\item{phi}{Numeric matrix.
The drift matrix
which represents the rate of change of the solution
in the absence of any random fluctuations
(\eqn{\boldsymbol{\Phi}}).}

\item{sigma}{Numeric matrix.
The covariance matrix of volatility
or randomness in the process
(\eqn{\boldsymbol{\Sigma}}).}
}
\description{
The steady-state covariance matrix is the solution
to the Sylvester equation,
i.e.
\deqn{
  \mathbf{A} \mathbf{X} +
  \mathbf{X} \mathbf{B} +
  \mathbf{C} = \mathbf{0} ,
} where \eqn{\mathbf{X}} is unknown,
\eqn{\mathbf{A} = \boldsymbol{\Phi}},
\eqn{\mathbf{B} = \boldsymbol{\Phi}^{\prime}}, and
\eqn{\mathbf{C} = \boldsymbol{\Sigma}}.
}
\examples{
phi <- matrix(
  data = c(
    -0.10,
    0.05,
    0.05,
    -0.10
  ),
  nrow = 2
)
sigma <- matrix(
  data = c(
    2.79,
    0.06,
    0.06,
    3.27
  ),
  nrow = 2
)
LinSDECov(phi = phi, sigma = sigma)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDEMean}()},
\code{\link{SimBetaN}()},
\code{\link{SimPhiN}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{TestPhi}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{linsde}
\keyword{sim}
\keyword{simStateSpace}
