% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep.R
\name{sim_studies}
\alias{sim_studies}
\title{Simulate studies.}
\usage{
sim_studies(
  df_visit,
  df_site,
  r = 100,
  poisson_test = TRUE,
  prob_lower = TRUE,
  r_prob_lower = 1000,
  parallel = FALSE,
  keep_ae = FALSE,
  min_n_pat_with_med75 = 1,
  studies = NULL,
  .progress = TRUE
)
}
\arguments{
\item{df_visit}{dataframe}

\item{df_site}{dataframe}

\item{r}{integer, denotes number of simulations, Default: 1000}

\item{poisson_test}{logical, calculates poisson.test pvalue, Default: TRUE}

\item{prob_lower}{logical, calculates probability for getting a lower value,
Default: FALSE}

\item{r_prob_lower}{integer, denotes number of simulations for prob_lower
value calculation,, Default: 1000}

\item{parallel}{logical, see examples for registering parallel processing framework
, Default: FALSE}

\item{keep_ae}{logical, keep ae numbers in output dataframe memory increase
roughly 30 percent, Default: F}

\item{min_n_pat_with_med75}{integer, min number of patients with med75 at
site to simulate, Default: 1}

\item{studies}{vector with study names, Default: NULL}

\item{.progress}{logical, show progress bar}
}
\value{
dataframe
}
\description{
Test function, test applicability of poisson test, by
calculating a the bootstrapped probability of obtaining a specific p-value
or lower, use in combination with \code{\link[=get_ecd_values]{get_ecd_values()}}.
}
\details{
Here we simulate study replicates maintaining the same number of
sites, patients and visit_med75 by bootstrap resampling, then probabilities
for obtaining lower or same mean_ae count and p-values using poisson.test
are calculated.

adds column with simulated probabilities for equal or lower
mean_ae at visit_med75
}
\examples{
\donttest{
df_visit1 <- sim_test_data_study(n_pat = 100, n_sites = 5,
                                      frac_site_with_ur = 0.4, ur_rate = 0.6)

df_visit1$study_id <- "A"

df_visit2 <- sim_test_data_study(n_pat = 1000, n_sites = 3,
                                      frac_site_with_ur = 0.2, ur_rate = 0.1)

df_visit2$study_id <- "B"

df_visit <- dplyr::bind_rows(df_visit1, df_visit2)

df_site <- site_aggr(df_visit)

sim_studies(df_visit, df_site, r = 3, keep_ae = TRUE)
}
\dontrun{
# parallel processing -------------------------
library(future)
future::plan(multiprocess)
sim_studies(df_visit, df_site, r = 3, keep_ae = TRUE, parallel = TRUE)
future::plan(sequential)
}
}
