% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulation.r
\name{simobs}
\alias{simobs}
\title{Simulate Observed Data}
\usage{
simobs(DAG, n, wide = TRUE, LTCF = NULL, rndseed = NULL,
  verbose = getOption("simcausal.verbose"))
}
\arguments{
\item{DAG}{A DAG objects that has been locked with set.DAG(DAG). Observed data from this DAG will be simulated.}

\item{n}{Number of observations to sample.}

\item{wide}{A logical, if TRUE the output data is generated in wide format, if FALSE, the output longitudinal data in generated in long format}

\item{LTCF}{If forward imputation is desired for the missing variable values, this argument should be set to the name of the node that indicates the end of follow-up event. See the vignette, \code{\link{sim}} and \code{\link{doLTCF}} for additional details.}

\item{rndseed}{Seed for the random number generator.}

\item{verbose}{\code{TRUE} turns on printing of auxiliary information messages. To rurn this off by default use \code{options(simcausal.verbose=FALSE)}.}
}
\value{
A \code{data.frame} where each column is sampled from the conditional distribution specified by the corresponding \code{DAG} object node.
}
\description{
This function simulates observed data from a DAG object.
}
\seealso{
\code{\link{simfull}} - a wrapper function for simulating full data only; \code{\link{sim}} - a wrapper function for simulating both types of data; \code{\link{doLTCF}} for forward imputation of the missing values in already simulating data; \code{\link{DF.to.long}}, \code{\link{DF.to.longDT}} - converting longitudinal data from wide to long formats.

Other simulation.functions: \code{\link{simfull}};
  \code{\link{sim}}
}

