% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{partial}
\alias{partial}
\title{Define partial function}
\usage{
partial(f, ...)
}
\arguments{
\item{f}{Function in two or more parameters.}

\item{...}{Parameters to be held fixed for function \code{f}.}
}
\value{
Function object.
}
\description{
Partial functions are useful to define marginal distributions based on
additional parameters.
}
\details{
This helper function stores passed arguments in a list, and stores this
list in the environment of the returned function. Thus, it remembers the
arguments that should be held fixed, such that the returned partial function
now is a function with fewer arguments.
}
\examples{
marginal <- partial(function(x, meanx) qnorm(x, meanx), meanx = 2)
marginal(0.5)

}
