% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Genotype.r
\name{cal.eff}
\alias{cal.eff}
\title{QTN genetic effects}
\usage{
cal.eff(
  qtn.num = 10,
  qtn.dist = "norm",
  qtn.var = 1,
  qtn.prob = 0.5,
  qtn.shape = 1,
  qtn.scale = 1,
  qtn.shape1 = 1,
  qtn.shape2 = 1,
  qtn.ncp = 0
)
}
\arguments{
\item{qtn.num}{integer: the QTN number of single trait; vector: the multiple group QTN number of single trait; matrix: the QTN number of multiple traits.}

\item{qtn.dist}{the QTN distribution containing 'norm', 'geom', 'gamma' or 'beta'.}

\item{qtn.var}{the standard deviations for normal distribution.}

\item{qtn.prob}{the probability of success for geometric distribution.}

\item{qtn.shape}{the shape parameter for gamma distribution.}

\item{qtn.scale}{the scale parameter for gamma distribution.}

\item{qtn.shape1}{the shape1 parameter for beta distribution.}

\item{qtn.shape2}{the shape2 parameter for beta distribution.}

\item{qtn.ncp}{the ncp parameter for beta distribution.}
}
\value{
a vector of genetic effect.
}
\description{
Calculate for genetic effects vector of selected markers.
}
\details{
Build date: Nov 14, 2018
Last update: Apr 28, 2022
}
\examples{
eff <- cal.eff(qtn.num = 10)
str(eff)
}
\author{
Dong Yin
}
