% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Data.R
\name{simer.Data.cHIBLUP}
\alias{simer.Data.cHIBLUP}
\title{Genetic evaluation}
\usage{
simer.Data.cHIBLUP(
  jsonList = NULL,
  hiblupPath = "",
  mode = "A",
  vc.method = "AI",
  ncpus = 10,
  verbose = TRUE
)
}
\arguments{
\item{jsonList}{the list of genetic evaluation parameters.}

\item{hiblupPath}{the path of HIBLUP software.}

\item{mode}{'A' or 'AD', Additive effect model or Additive and Dominance model.}

\item{vc.method}{default is 'AI', the method of calculating variance components in HIBLUP software.}

\item{ncpus}{the number of threads used, if NULL, (logical core number - 1) is automatically used.}

\item{verbose}{whether to print detail.}
}
\value{
the function returns a list containing
\describe{
\item{$randList}{a list of estimated random effects.}
\item{$varList}{a list of variance components.}
\item{$covA}{the genetic covariance matrix for all traits.}
\item{$corA}{the genetic correlation matrix for all traits.}
}
}
\description{
The function of calling HIBLUP software of C version.
}
\details{
Build date: June 28, 2021
Last update: Apr 28, 2022
}
\examples{
# Read JSON file
jsonFile <- system.file("extdata", "04breeding_plan", "plan1.json", package = "simer")
jsonList <- jsonlite::fromJSON(txt = jsonFile, simplifyVector = FALSE)

\dontrun{
# It needs 'hiblup' software
gebvs <- simer.Data.cHIBLUP(jsonList = jsonList)
}
}
\author{
Dong Yin
}
