% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/admix_last_gen.R
\name{admix_last_gen}
\alias{admix_last_gen}
\title{Calculate admixture matrix for last generation of a pedigree with admixture of founders}
\usage{
admix_last_gen(admix, fam, ids, missing_vals = c("", 0))
}
\arguments{
\item{admix}{The admixture proportions matrix of the founders (individuals along rows and ancestries along columns).
This matrix must have row names that identify each founder (matching codes in \code{fam$id}).
Individuals may be in a different order than \code{fam$id}.
Extra individuals in \code{admix} but absent in \code{fam$id} will be silently ignored.
All values should be non-negative and each row of \code{admix} should sum to one; for speed, this code does not check that \code{admix} is valid, just averages data as-is.}

\item{fam}{The pedigree data.frame, in plink FAM format.
Only columns \code{id}, \code{pat}, and \code{mat} are required.
\code{id} must be unique and non-missing.
Founders must be present, and their \code{pat} and \code{mat} values must be missing (see below).
Non-founders must have both their parents be non-missing.
Parents must appear earlier than their children in the table.}

\item{ids}{A list containing vectors of IDs for each generation.
All these IDs must be present in \code{fam$id}.
If IDs in \code{fam} and \code{ids} do not fully agree, the code processes the IDs in the intersection, which is helpful when \code{fam} is pruned but \code{ids} is the original (larger) set.}

\item{missing_vals}{The list of ID values treated as missing.
\code{NA} is always treated as missing.
By default, the empty string ('') and zero (0) are also treated as missing (remove values from here if this is a problem).}
}
\value{
The admixture proportions matrix of the last generation (the intersection of \code{ids[ length(ids) ]} and \code{fam$id}).
The rows of this matrix are last-generation individuals in the order that they appear in \code{fam$id}.
}
\description{
A wrapper around the more general \code{\link[=admix_fam]{admix_fam()}}, specialized to save memory when only the last generation is desired (\code{\link[=admix_fam]{admix_fam()}} returns admixture for the entire pedigree in a single matrix).
This function assumes that generations are non-overlapping (met by the output of \code{\link[=sim_pedigree]{sim_pedigree()}}), in which case each generation \code{g} can be drawn from generation \code{g-1} data only.
That way, only two consecutive generations need be in memory at any given time.
The partitioning of individuals into generations is given by the \code{ids} parameter (again matches the output of \code{\link[=sim_pedigree]{sim_pedigree()}}).
}
\examples{
# A small pedigree, two parents and two children.
# A minimal fam table with the three required columns.
# Note "mother" and "father" have missing parent IDs, while children do not
library(tibble)
fam <- tibble(
  id = c('father', 'mother', 'child', 'sib'),
  pat = c(NA, NA, 'father', 'father'),
  mat = c(NA, NA, 'mother', 'mother')
)
# need an `ids` list separating the generations
ids <- list( c('father', 'mother'), c('child', 'sib') )

# admixture proportions of the parents
admix <- rbind( c(0.3, 0.3, 0.4), c(0.5, 0.25, 0.25) )
# Name the parents with same codes as in `fam`
# (order can be different)
rownames( admix ) <- c('mother', 'father')
# name ancestries too
colnames( admix ) <- c('African', 'European', 'Asian')

# calculate the admixture matrix of the children
admix2 <- admix_last_gen( admix, fam, ids )
admix2

}
\seealso{
Plink FAM format reference:
\url{https://www.cog-genomics.org/plink/1.9/formats#fam}
}
