% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit.R
\name{visit}
\alias{visit}
\alias{visit_selected}
\title{Visit a Resource}
\usage{
visit(.trj, resource, task, amount = 1)

visit_selected(.trj, task, amount = 1, id = 0)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{resource}{the name of the resource.}

\item{task}{the timeout duration supplied by either passing a numeric or a
callable object (a function) which must return a numeric (negative values are
automatically coerced to positive).}

\item{amount}{the amount to seize/release, accepts either a numeric or a
callable object (a function) which must return a numeric.}

\item{id}{selection identifier for nested usage.}
}
\value{
Returns the following chain of activities: \code{\link[simmer]{seize}}
> \code{\link[simmer]{timeout}} > \code{\link[simmer:seize]{release}}
(see examples below).
}
\description{
These bricks encapsulate a resource visit: seize, spend some time and release.
}
\examples{
## These are equivalent:
trajectory() \%>\%
  visit("res", 5, 1)

trajectory() \%>\%
  seize("res", 1) \%>\%
  timeout(5) \%>\%
  release("res", 1)

## These are equivalent:
trajectory() \%>\%
  visit_selected(5, 1)

trajectory() \%>\%
  seize_selected(1) \%>\%
  timeout(5) \%>\%
  release_selected(1)

}
