% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.arrivals.R, R/plot.attributes.R,
%   R/plot.resources.R, R/simmer.plot.R
\name{plot.mon}
\alias{plot.mon}
\alias{plot.arrivals}
\alias{plot.mon}
\alias{plot.attributes}
\alias{plot.mon}
\alias{plot.resources}
\alias{plot.mon}
\title{Plot Methods for \code{simmer} Monitoring Statistics}
\usage{
\method{plot}{arrivals}(x, metric = c("activity_time", "waiting_time",
  "flow_time"), ...)

\method{plot}{attributes}(x, metric = NULL, keys, ...)

\method{plot}{resources}(x, metric = c("usage", "utilization"), names, ...)
}
\arguments{
\item{x}{a data frame of class \code{arrivals}/\code{attributes}/\code{resources}
(see \code{\link{get_mon}}).}

\item{metric}{specific metric to compute.}

\item{...}{further arguments
\describe{
  \item{\code{items}, for \code{plot.resources(metric="usage")}}{components of
  the resource to plot, one or more of \code{c("system", "queue", "server")}.}
  \item{\code{steps}, for \code{plot.resources(metric="usage")}}{if \code{TRUE},
  shows the instantaneous usage instead of the cumulative average.}
}}

\item{keys}{attributes to plot (if left empty, all attributes are shown).}

\item{names}{resources to plot (if left empty, all resources are shown).}
}
\value{
Returns a ggplot2 object.
}
\description{
Methods for the \code{\link{plot}} generic.
}
\examples{
t0 <- trajectory("my trajectory") \%>\%
  ## add an intake activity
  seize("nurse", 1) \%>\%
  timeout(function() rnorm(1, 15)) \%>\%
  release("nurse", 1) \%>\%
  ## add a consultation activity
  seize("doctor", 1) \%>\%
  timeout(function() rnorm(1, 20)) \%>\%
  release("doctor", 1) \%>\%
  ## add a planning activity
  seize("administration", 1) \%>\%
  timeout(function() rnorm(1, 5)) \%>\%
  release("administration", 1)

env <- simmer("SuperDuperSim") \%>\%
  add_resource("nurse", 1) \%>\%
  add_resource("doctor", 2) \%>\%
  add_resource("administration", 1) \%>\%
  add_generator("patient", t0, function() rnorm(1, 10, 2)) \%>\%
  run(until=80)

resources <- get_mon_resources(env)
arrivals <- get_mon_arrivals(env)

plot(resources, metric="usage", "doctor", items = "server", steps = TRUE)
plot(resources, metric="utilization", c("nurse", "doctor", "administration"))
plot(arrivals, metric="waiting_time")

}
