% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.trajectory.R
\name{plot.trajectory}
\alias{plot.trajectory}
\title{Plot method for trajectory objects}
\usage{
\method{plot}{trajectory}(x, engine = "dot", ...)
}
\arguments{
\item{x}{a simmer trajectory.}

\item{engine}{a string specifying a layout engine (see \code{\link{grViz}}).}

\item{...}{additional parameters for \code{\link{render_graph}}.}
}
\value{
Returns an \code{htmlwidget}.
}
\description{
A method for the \code{\link{plot}} generic that plots a diagram of the given trajectory.
}
\examples{
x <- trajectory() \%>\%
seize("resource", 1) \%>\%
  timeout(function() rnorm(1, 15)) \%>\%
  release("resource", 1) \%>\%
  branch(function() 1, c(TRUE, FALSE),
         trajectory() \%>\%
           clone(2,
                 trajectory() \%>\%
                   seize("resource", 1) \%>\%
                   timeout(1) \%>\%
                   release("resource", 1),
                 trajectory() \%>\%
                   trap("signal",
                        handler=trajectory() \%>\%
                          timeout(1)) \%>\%
                   timeout(1)),
         trajectory() \%>\%
           set_attribute("dummy", 1) \%>\%
           set_attribute("dummy", function() 1) \%>\%
           seize("resource", function() 1) \%>\%
           timeout(function() rnorm(1, 20)) \%>\%
           release("resource", function() 1) \%>\%
           rollback(9)) \%>\%
  timeout(1) \%>\%
  rollback(2)

plot(x)
}

