% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{clone}
\alias{clone}
\alias{synchronize}
\title{Add a clone/synchronize activity}
\usage{
clone(.trj, n, ...)

synchronize(.trj, wait = TRUE, mon_all = FALSE)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{n}{number of clones, accepts either a numeric or a callable object
(a function) which must return a numeric.}

\item{...}{optional parallel sub-trajectories. Each clone will follow
a different sub-trajectory if available.}

\item{wait}{if \code{FALSE}, all clones but the first to arrive are removed.
if \code{TRUE} (default), all clones but the last to arrive are removed.}

\item{mon_all}{if \code{TRUE}, \code{get_mon_arrivals} will show one
line per clone.}
}
\value{
Returns the trajectory object.
}
\description{
A \code{clone} activity replicates an arrival \code{n} times (the original
one + \code{n-1} copies). A \code{synchronize} activity removes all but one clone.
}

