// Copyright (C) 2018-2020 Iñaki Ucar
//
// This file is part of simmer.
//
// simmer is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// simmer is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with simmer. If not, see <http://www.gnu.org/licenses/>.

#ifndef simmer__h
#define simmer__h

#include <simmer/common.h>
#include <simmer/simulator.h>

#include <simmer/monitor.h>
#include <simmer/monitor/memory.h>
#include <simmer/monitor/csv.h>

#include <simmer/activity.h>
#include <simmer/activity/fork.h>
#include <simmer/activity/storage.h>
#include <simmer/activity/debug.h>
#include <simmer/activity/timeout.h>
#include <simmer/activity/arrival.h>
#include <simmer/activity/resource.h>
#include <simmer/activity/source.h>
#include <simmer/activity/branch.h>
#include <simmer/activity/rollback.h>
#include <simmer/activity/renege.h>
#include <simmer/activity/async.h>

#include <simmer/process.h>
#include <simmer/process/task.h>
#include <simmer/process/manager.h>
#include <simmer/process/source.h>
#include <simmer/process/generator.h>
#include <simmer/process/datasrc.h>
#include <simmer/process/arrival.h>
#include <simmer/process/batched.h>

#include <simmer/resource.h>
#include <simmer/resource/types.h>
#include <simmer/resource/priority.h>
#include <simmer/resource/preemptive.h>

#include <simmer/simulator_impl.h>
#include <simmer/process/arrival_impl.h>

#endif
