% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_scatter_fun.R
\name{ggplot_scatter}
\alias{ggplot_scatter}
\title{Scatter ggplot.}
\usage{
ggplot_scatter(data, x_var, y_var, hover_var = NULL, size = 1,
  pal = NULL, x_scale_zero = TRUE, x_scale_zero_line = TRUE,
  x_scale_trans = "identity", x_scale_labels = waiver(),
  y_scale_zero = TRUE, y_scale_zero_line = TRUE,
  y_scale_trans = "identity", y_scale_labels = waiver(),
  title = "[Title]", subtitle = NULL, x_title = "[X title]",
  y_title = "[Y title]", caption = NULL, font_family = "Helvetica",
  font_size_title = NULL, font_size_body = NULL, wrap_title = 70,
  wrap_subtitle = 80, wrap_x_title = 50, wrap_y_title = 50,
  wrap_caption = 80, isMobile = FALSE)
}
\arguments{
\item{data}{An ungrouped summarised tibble or dataframe. Required input.}

\item{x_var}{Unquoted numeric variable to be on the x axis. Required input.}

\item{y_var}{Unquoted numeric variable to be on the y axis. Required input.}

\item{hover_var}{Unquoted variable to be an additional hover variable for when used inside plotly::ggplotly(). Defaults to NULL.}

\item{size}{Size of points. Defaults to 1.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the Stats NZ palette.}

\item{x_scale_zero}{TRUE or FALSE whether the minimum of the x scale is zero. Defaults to TRUE.}

\item{x_scale_zero_line}{TRUE or FALSE whether to add a zero line in for when values are above and below zero. Defaults to TRUE.}

\item{x_scale_trans}{A string specifying a transformation for the x scale. Defaults to "identity".}

\item{x_scale_labels}{Argument to adjust the format of the x scale labels.}

\item{y_scale_zero}{TRUE or FALSE whether the minimum of the y scale is zero. Defaults to TRUE.}

\item{y_scale_zero_line}{TRUE or FALSE whether to add a zero line in for when values are above and below zero. Defaults to TRUE.}

\item{y_scale_trans}{A string specifying a transformation for the y scale. Defaults to "identity".}

\item{y_scale_labels}{Argument to adjust the format of the y scale labels.}

\item{title}{Title string. Defaults to "[Title]".}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{x_title}{X axis title string. Defaults to "[X title]".}

\item{y_title}{Y axis title string. Defaults to "[Y title]".}

\item{caption}{Caption title string. Defaults to NULL.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{wrap_title}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{wrap_subtitle}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{wrap_x_title}{Number of characters to wrap the x title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_y_title}{Number of characters to wrap the y title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_caption}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. In a shinyapp, isMobile should be specified as input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Scatter ggplot that is not coloured and not facetted.
}
\examples{
plot_data <- dplyr::sample_frac(ggplot2::diamonds, 0.05)

plot <- ggplot_scatter(data = plot_data, x_var = carat, y_var = price,
   title = "Diamond price by carat",
   x_title = "Carat",
   y_title = "Price ($US thousands)")

plot

plotly::ggplotly(plot, tooltip = "text")
}
