% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet_sf_fun.R
\name{leaflet_sf}
\alias{leaflet_sf}
\title{Map of simple features in leaflet.}
\usage{
leaflet_sf(data, pal = NULL,
  popup = leafpop::popupTable(sentence_spaced_colnames(data)),
  radius = 1, weight = 2, opacity = 0.1, stroke = TRUE,
  title = "[Title]", legend_digits = 1, legend_labels = "[Feature]",
  basemap = "light", map_id = "map")
}
\arguments{
\item{data}{An sf object of geometry type point/multipoint, linestring/multilinestring or polygon/multipolygon geometry type. Required input.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the Stats NZ palette.}

\item{popup}{HTML strings for use in popup. Defaults to making a leafpop::popupTable of all attribute columns in the sf object.}

\item{radius}{Radius of points. Defaults to 2.}

\item{weight}{Stroke border size. Defaults to 2.}

\item{opacity}{The opacity of the fill. Defaults to 0.1. Only applicable to polygons.}

\item{stroke}{TRUE or FALSE of whether to draw a border around the features. Defaults to TRUE.}

\item{title}{A title string that will be wrapped into the legend. Defaults to "Title"}

\item{legend_digits}{Select the appropriate number of decimal places for numeric variable auto legend labels. Defaults to 1.}

\item{legend_labels}{A vector of legend label values. Defaults to "Feature".}

\item{basemap}{The underlying basemap. Either "light", "dark", "satellite", "street", or "ocean". Defaults to "light". Only applicable where shiny equals FALSE.}

\item{map_id}{The shiny map id for a leaflet map within a shiny app. For standard single-map apps, id "map" should be used. For dual-map apps, "map1" and "map2" should be used. Defaults to "map".}
}
\value{
A leaflet object.
}
\description{
Map of simple features in leaflet that is not coloured.
}
\examples{
map_data <- example_sf_nz_river_wq \%>\%
  dplyr::filter(period == "1998-2017", indicator == "Nitrate-nitrogen")

leaflet_sf(map_data)
}
