% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_stars_fun.R
\name{ggplot_stars_col}
\alias{ggplot_stars_col}
\title{Map of an array in ggplot that is coloured.}
\usage{
ggplot_stars_col(data, col_method = "quantile", col_cuts = NULL,
  pal = NULL, pal_rev = FALSE, legend_ncol = 3, legend_digits = 1,
  title = "[Title]", subtitle = NULL, col_title = "",
  caption = NULL, legend_labels = NULL, font_family = "Helvetica",
  font_size_title = NULL, font_size_body = NULL, title_wrap = 70,
  subtitle_wrap = 80, wrap_col_title = 25, caption_wrap = 80,
  isMobile = FALSE)
}
\arguments{
\item{data}{A stars object with 2 dimensions x and y, and 1 attribute layer that will be coloured. Required input.}

\item{col_method}{The method of colouring grid, either "bin", "quantile" or "category." Defaults to "quantile".}

\item{col_cuts}{A vector of cuts to colour a numeric variable. If "bin" is selected, the first number in the vector should be either -Inf or 0, and the final number Inf. If "quantile" is selected, the first number in the vector should be 0 and the final number should be 1. Defaults to quartiles.}

\item{pal}{Character vector of hex codes, or provided objects with pal_ prefixes. Defaults to viridis.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{legend_ncol}{The number of columns in the legend.}

\item{legend_digits}{Select the appropriate number of decimal places for numeric variable auto legend labels. Defaults to 1.}

\item{title}{Title string. Defaults to "[Title]".}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{col_title}{Colour title string for the legend. Defaults to NULL.}

\item{caption}{Caption title string. Defaults to NULL.}

\item{legend_labels}{A vector of manual legend label values. Defaults to NULL, which results in automatic labels.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{wrap_col_title}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where isMobile equals TRUE.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. If within an app with the mobileDetect function, then use isMobile = input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Map of an array in ggplot that is coloured, but not facetted.
}
\examples{
ggplot_stars_col(data = example_stars, 
   col_method = "quantile", col_cuts = c(0, 0.05, 0.25, 0.5, 0.75, 0.95, 1),
   title = "Site medians, 2013-17")
}
